/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.OB.Assert;
import com.ooc.OB.Logger;
import java.util.Enumeration;
import java.util.Properties;

public final class EventLogger {
    Logger logger_;
    int traceEvents_ = 0;
    int traceLifecycle_ = 0;

    public EventLogger(Logger logger, Properties properties) {
        this.logger_ = logger;
        String propRoot = "ooc.event.trace.";
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(propRoot)) continue;
            String value = properties.getProperty(key);
            Assert._OB_assert((value != null ? 1 : 0) != 0);
            if (key.equals("ooc.event.trace.events")) {
                try {
                    this.traceEvents_ = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    this.logger_.warning("Invalid value for ooc.event.trace.events");
                }
                continue;
            }
            if (key.equals("ooc.event.trace.lifecycle")) {
                try {
                    this.traceLifecycle_ = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    this.logger_.warning("Invalid value for ooc.event.trace.lifecycle");
                }
                continue;
            }
            this.logger_.warning("event: unknown property: " + key);
        }
    }

    public int traceEvents() {
        return this.traceEvents_;
    }

    public int traceLifecycle() {
        return this.traceLifecycle_;
    }

    public void info(String msg) {
        this.logger_.info(msg);
    }

    public void error(String msg) {
        this.logger_.error(msg);
    }

    public void warning(String msg) {
        this.logger_.warning(msg);
    }

    public void trace(String category, String msg) {
        this.logger_.trace(category, msg);
    }
}

