/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosPropertyService;

import com.ooc.CosPropertyService.PropertiesIterator_impl;
import com.ooc.CosPropertyService.PropertyNamesIterator_impl;
import com.ooc.OB.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosPropertyService.ConflictingProperty;
import org.omg.CosPropertyService.ExceptionReason;
import org.omg.CosPropertyService.FixedProperty;
import org.omg.CosPropertyService.InvalidPropertyName;
import org.omg.CosPropertyService.MultipleExceptions;
import org.omg.CosPropertyService.PropertiesHolder;
import org.omg.CosPropertyService.PropertiesIteratorHolder;
import org.omg.CosPropertyService.Property;
import org.omg.CosPropertyService.PropertyDef;
import org.omg.CosPropertyService.PropertyDefsHolder;
import org.omg.CosPropertyService.PropertyException;
import org.omg.CosPropertyService.PropertyMode;
import org.omg.CosPropertyService.PropertyModeType;
import org.omg.CosPropertyService.PropertyModesHolder;
import org.omg.CosPropertyService.PropertyNamesHolder;
import org.omg.CosPropertyService.PropertyNamesIteratorHolder;
import org.omg.CosPropertyService.PropertyNotFound;
import org.omg.CosPropertyService.PropertySetDefPOA;
import org.omg.CosPropertyService.PropertyTypesHolder;
import org.omg.CosPropertyService.ReadOnlyProperty;
import org.omg.CosPropertyService.UnsupportedMode;
import org.omg.CosPropertyService.UnsupportedProperty;
import org.omg.CosPropertyService.UnsupportedTypeCode;
import org.omg.PortableServer.POA;

public final class PropertySetDef_impl
extends PropertySetDefPOA {
    private ORB orb_;
    private POA poa_;
    private Hashtable properties_;
    private TypeCode[] allowedTypes_;
    private PropertyDef[] allowedProperties_;
    private static Any any_;

    public PropertySetDef_impl(POA poa, ORB orb) {
        this.poa_ = poa;
        this.orb_ = orb;
        this.properties_ = new Hashtable();
    }

    public PropertySetDef_impl(POA poa, ORB orb, TypeCode[] allowed_property_types, PropertyDef[] allowed_property_defs) {
        this.poa_ = poa;
        this.orb_ = orb;
        this.properties_ = new Hashtable();
        this.allowedTypes_ = allowed_property_types;
        this.allowedProperties_ = allowed_property_defs;
    }

    public PropertySetDef_impl(POA poa, ORB orb, PropertyDef[] initial_property_defs) {
        this.poa_ = poa;
        this.orb_ = orb;
        this.properties_ = initial_property_defs.length != 0 ? new Hashtable(2 * initial_property_defs.length) : new Hashtable();
        for (int i = 0; i < initial_property_defs.length; ++i) {
            this.properties_.put(initial_property_defs[i].property_name, initial_property_defs[i]);
        }
    }

    public void define_property(String property_name, Any property_value) throws InvalidPropertyName, ConflictingProperty, UnsupportedTypeCode, UnsupportedProperty, ReadOnlyProperty {
        try {
            this.define_property_with_mode(property_name, property_value, PropertyModeType.undefined);
        }
        catch (UnsupportedMode ex) {
            Assert._OB_assert((boolean)false);
        }
    }

    public void define_properties(Property[] nproperties) throws MultipleExceptions {
        int len = nproperties.length;
        PropertyDef[] p = new PropertyDef[len];
        for (int i = 0; i < len; ++i) {
            p[i] = new PropertyDef(nproperties[i].property_name, nproperties[i].property_value, PropertyModeType.undefined);
        }
        this.define_properties_with_modes(p);
    }

    public synchronized int get_number_of_properties() {
        return this.properties_.size();
    }

    public synchronized void get_all_property_names(int how_many, PropertyNamesHolder property_names, PropertyNamesIteratorHolder rest) {
        int i;
        int len = this.properties_.size();
        int num = len < how_many ? len : how_many;
        property_names.value = new String[num];
        Enumeration e = this.properties_.keys();
        for (i = 0; i < num; ++i) {
            property_names.value[i] = (String)e.nextElement();
        }
        if (how_many < len) {
            String[] rem = new String[len - how_many];
            for (i = 0; i < len - how_many; ++i) {
                rem[i] = (String)e.nextElement();
            }
            PropertyNamesIterator_impl iteratorImpl = new PropertyNamesIterator_impl(rem);
            rest.value = iteratorImpl._this(this.orb_);
        }
    }

    public synchronized Any get_property_value(String property_name) throws PropertyNotFound, InvalidPropertyName {
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        PropertyDef p = (PropertyDef)this.properties_.get(property_name);
        if (p == null) {
            throw new PropertyNotFound();
        }
        return p.property_value;
    }

    public synchronized boolean get_properties(String[] property_names, PropertiesHolder nproperties) {
        Vector<Property> properties = new Vector<Property>(property_names.length);
        boolean allNamesAreValid = true;
        for (int i = 0; i < property_names.length; ++i) {
            PropertyDef p = (PropertyDef)this.properties_.get(property_names[i]);
            if (p != null) {
                properties.addElement(new Property(p.property_name, p.property_value));
                continue;
            }
            if (any_ == null) {
                any_ = this.orb_.create_any();
                any_.type(this.orb_.get_primitive_tc(TCKind.tk_void));
            }
            properties.addElement(new Property(property_names[i], any_));
            allNamesAreValid = false;
        }
        nproperties.value = new Property[properties.size()];
        properties.copyInto(nproperties.value);
        return allNamesAreValid;
    }

    public synchronized void get_all_properties(int how_many, PropertiesHolder nproperties, PropertiesIteratorHolder rest) {
        int i;
        int len = this.properties_.size();
        int num = len < how_many ? len : how_many;
        nproperties.value = new Property[num];
        Enumeration e = this.properties_.elements();
        for (i = 0; i < num; ++i) {
            PropertyDef pd = (PropertyDef)e.nextElement();
            nproperties.value[i] = new Property(pd.property_name, pd.property_value);
        }
        if (how_many < len) {
            PropertyDef[] rem = new PropertyDef[len - how_many];
            for (i = 0; i < len - how_many; ++i) {
                rem[i] = (PropertyDef)e.nextElement();
            }
            PropertiesIterator_impl propertiesIteratorImpl = new PropertiesIterator_impl(this.orb_, rem);
            rest.value = propertiesIteratorImpl._this(this.orb_);
        }
    }

    public synchronized void delete_property(String property_name) throws PropertyNotFound, InvalidPropertyName, FixedProperty {
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        PropertyDef p = (PropertyDef)this.properties_.get(property_name);
        if (p == null) {
            throw new PropertyNotFound();
        }
        if (p.property_mode == PropertyModeType.fixed_normal || p.property_mode == PropertyModeType.fixed_readonly) {
            throw new FixedProperty();
        }
        this.properties_.remove(p.property_name);
    }

    public synchronized void delete_properties(String[] property_names) throws MultipleExceptions {
        Vector<PropertyException> exceptions = new Vector<PropertyException>();
        int len = property_names.length;
        for (int i = 0; i < len; ++i) {
            PropertyException ex;
            if (property_names[i].length() == 0) {
                PropertyException ex2 = new PropertyException(ExceptionReason.invalid_property_name, property_names[i]);
                exceptions.addElement(ex2);
                continue;
            }
            PropertyDef p = (PropertyDef)this.properties_.get(property_names[i]);
            if (p == null) {
                ex = new PropertyException(ExceptionReason.property_not_found, property_names[i]);
                exceptions.addElement(ex);
                continue;
            }
            if (p.property_mode == PropertyModeType.fixed_normal || p.property_mode == PropertyModeType.fixed_readonly) {
                ex = new PropertyException(ExceptionReason.fixed_property, property_names[i]);
                exceptions.addElement(ex);
                continue;
            }
            this.properties_.remove(property_names[i]);
        }
        if (!exceptions.isEmpty()) {
            Object[] ex = new PropertyException[exceptions.size()];
            exceptions.copyInto(ex);
            throw new MultipleExceptions((PropertyException[])ex);
        }
    }

    public synchronized boolean delete_all_properties() {
        Hashtable<String, PropertyDef> fixed = new Hashtable<String, PropertyDef>();
        Enumeration e = this.properties_.elements();
        while (e.hasMoreElements()) {
            PropertyDef p = (PropertyDef)e.nextElement();
            if (p.property_mode != PropertyModeType.fixed_normal && p.property_mode != PropertyModeType.fixed_readonly) continue;
            fixed.put(p.property_name, p);
        }
        this.properties_ = fixed;
        return this.properties_.size() == 0;
    }

    public synchronized boolean is_property_defined(String property_name) throws InvalidPropertyName {
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        return this.properties_.containsKey(property_name);
    }

    public void get_allowed_property_types(PropertyTypesHolder property_types) {
        property_types.value = this.allowedTypes_;
    }

    public void get_allowed_properties(PropertyDefsHolder property_defs) {
        property_defs.value = this.allowedProperties_;
    }

    public synchronized void define_property_with_mode(String property_name, Any property_value, PropertyModeType property_mode) throws InvalidPropertyName, ConflictingProperty, UnsupportedTypeCode, UnsupportedProperty, UnsupportedMode, ReadOnlyProperty {
        this.check(property_name, property_value, property_mode);
        PropertyDef p = (PropertyDef)this.properties_.get(property_name);
        if (p != null) {
            if (p.property_mode == PropertyModeType.read_only || p.property_mode == PropertyModeType.fixed_readonly) {
                throw new ReadOnlyProperty();
            }
            if (!p.property_value.type().equal(property_value.type())) {
                throw new ConflictingProperty();
            }
            p.property_value = property_value;
        } else {
            this.properties_.put(property_name, new PropertyDef(property_name, property_value, property_mode));
        }
    }

    public synchronized void define_properties_with_modes(PropertyDef[] property_defs) throws MultipleExceptions {
        Vector<PropertyException> exceptions = new Vector<PropertyException>();
        int len = property_defs.length;
        for (int i = 0; i < len; ++i) {
            PropertyException e;
            try {
                this.check(property_defs[i].property_name, property_defs[i].property_value, property_defs[i].property_mode);
            }
            catch (InvalidPropertyName ex) {
                e = new PropertyException(ExceptionReason.invalid_property_name, property_defs[i].property_name);
                exceptions.addElement(e);
                continue;
            }
            catch (UnsupportedTypeCode ex) {
                e = new PropertyException(ExceptionReason.unsupported_type_code, property_defs[i].property_name);
                exceptions.addElement(e);
                continue;
            }
            catch (UnsupportedProperty ex) {
                e = new PropertyException(ExceptionReason.unsupported_property, property_defs[i].property_name);
                exceptions.addElement(e);
                continue;
            }
            PropertyDef p = (PropertyDef)this.properties_.get(property_defs[i].property_name);
            if (p != null) {
                PropertyException ex;
                if (p.property_mode == PropertyModeType.read_only || p.property_mode == PropertyModeType.fixed_readonly) {
                    ex = new PropertyException(ExceptionReason.read_only_property, property_defs[i].property_name);
                    exceptions.addElement(ex);
                    continue;
                }
                if (!p.property_value.type().equal(property_defs[i].property_value.type())) {
                    ex = new PropertyException(ExceptionReason.conflicting_property, property_defs[i].property_name);
                    exceptions.addElement(ex);
                    continue;
                }
                p.property_value = property_defs[i].property_value;
                continue;
            }
            this.properties_.put(property_defs[i].property_name, new PropertyDef(property_defs[i].property_name, property_defs[i].property_value, property_defs[i].property_mode));
        }
        if (!exceptions.isEmpty()) {
            Object[] ex = new PropertyException[exceptions.size()];
            exceptions.copyInto(ex);
            throw new MultipleExceptions((PropertyException[])ex);
        }
    }

    public synchronized PropertyModeType get_property_mode(String property_name) throws PropertyNotFound, InvalidPropertyName {
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        PropertyDef p = (PropertyDef)this.properties_.get(property_name);
        if (p == null) {
            throw new PropertyNotFound();
        }
        return p.property_mode;
    }

    public synchronized boolean get_property_modes(String[] property_names, PropertyModesHolder property_modes) {
        boolean allDefined = true;
        property_modes.value = new PropertyMode[property_names.length];
        int len = property_names.length;
        for (int i = 0; i < len; ++i) {
            PropertyDef p = (PropertyDef)this.properties_.get(property_names[i]);
            if (p != null) {
                property_modes.value[i] = new PropertyMode(p.property_name, p.property_mode);
                continue;
            }
            property_modes.value[i] = new PropertyMode(property_names[i], PropertyModeType.undefined);
            allDefined = false;
        }
        return allDefined;
    }

    public synchronized void set_property_mode(String property_name, PropertyModeType property_mode) throws InvalidPropertyName, PropertyNotFound, UnsupportedMode {
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        PropertyDef p = (PropertyDef)this.properties_.get(property_name);
        if (p == null) {
            throw new PropertyNotFound();
        }
        if (property_mode == PropertyModeType.undefined) {
            throw new UnsupportedMode();
        }
        p.property_mode = property_mode;
    }

    public synchronized void set_property_modes(PropertyMode[] property_modes) throws MultipleExceptions {
        Vector<PropertyException> exceptions = new Vector<PropertyException>();
        int len = property_modes.length;
        for (int i = 0; i < len; ++i) {
            PropertyException ex;
            if (property_modes[i].property_name.length() == 0) {
                PropertyException ex2 = new PropertyException(ExceptionReason.invalid_property_name, property_modes[i].property_name);
                exceptions.addElement(ex2);
                continue;
            }
            PropertyDef p = (PropertyDef)this.properties_.get(property_modes[i].property_name);
            if (p == null) {
                ex = new PropertyException(ExceptionReason.property_not_found, property_modes[i].property_name);
                exceptions.addElement(ex);
                continue;
            }
            if (property_modes[i].property_mode == PropertyModeType.undefined) {
                ex = new PropertyException(ExceptionReason.unsupported_mode, property_modes[i].property_name);
                exceptions.addElement(ex);
                continue;
            }
            p.property_mode = property_modes[i].property_mode;
        }
        if (!exceptions.isEmpty()) {
            Object[] ex = new PropertyException[exceptions.size()];
            exceptions.copyInto(ex);
            throw new MultipleExceptions((PropertyException[])ex);
        }
    }

    private void check(String property_name, Any property_value, PropertyModeType property_mode) throws InvalidPropertyName, UnsupportedTypeCode, UnsupportedProperty {
        int i;
        if (property_name.length() == 0) {
            throw new InvalidPropertyName();
        }
        if (this.allowedProperties_ != null) {
            boolean propertyIsAllowed = false;
            for (i = 0; i < this.allowedProperties_.length; ++i) {
                if (!this.allowedProperties_[i].property_name.equals(property_name)) continue;
                if (!this.allowedProperties_[i].property_value.type().equal(property_value.type())) {
                    throw new UnsupportedTypeCode();
                }
                if (property_mode != PropertyModeType.undefined && this.allowedProperties_[i].property_mode != property_mode) continue;
                propertyIsAllowed = true;
                break;
            }
            if (!propertyIsAllowed) {
                throw new UnsupportedProperty();
            }
        }
        if (this.allowedTypes_ != null) {
            boolean typeIsAllowed = false;
            for (i = 0; i < this.allowedTypes_.length; ++i) {
                if (!this.allowedTypes_[i].equal(property_value.type())) continue;
                typeIsAllowed = true;
                break;
            }
            if (!typeIsAllowed) {
                throw new UnsupportedTypeCode();
            }
        }
    }
}

