<?php
/**
* mosgtranslate.php 
* Mambot creating an dynamic link to Google translate for the current article.
* FOR MAMBO 4.5.2
* license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* author Nadir Boussoukaia 
* email: nad4reg@gmail.com
* web: http://nadir.is.online.fr
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botgtranslate' );

function botgtranslate( $published, &$row, &$params, $page=0 ) {
    global $database, $mainframe, $task,$mosConfig_live_site,$Itemid;
	if (!$published) return true;

	// Get Settings from Parameter-System
	$query = "SELECT id FROM #__mambots WHERE element = 'mosgtranslate' AND folder = 'content'";
	$database->setQuery( $query );
	$id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load( $id );

	$params =& new mosParameters( $mambot->params );

	$param_position=$params->get('textposition','0');
	$param_display=$params->get('wheretoshow','0');
	$param_fromlang=$params->get('fromlang','fr');
	$param_tolang=$params->get('tolang','en');
	$param_textbefore=$params->get('textbefore','');
	$param_textafter=$params->get('textafter','');
 	$param_showimage=$params->def( 'showimage', 1 );
	$param_css=$params->get('textcss','');

	$lang_strings = array(
		'en'=>'English',
		'de'=>'German',
		'fr'=>'French',
		'it'=>'Italian',
		'es'=>'Spanish',
		'pt'=>'Portuguese',
		'ja'=>'Japanese',
		'zh-CN'=>'Chinese (Simplified)',
		'ko'=>'Korean'
	);

	if 	( 
		($task=="view" && $param_display=="1")	// If setting is "only in blog"
	      ||		
	      ($task<>"view" && $param_display=="2")// If setting is "only in full view"
		) 
	{
		$row->author="";
		$row->created_by_alias="";
		return true;
	}


    $gt_url="http://translate.google.com/translate?langpair=<FROM>%7C<TO>&hl=<TO>&ie=UTF-8&oe=UTF-8&u=<URL>";
	
//    $this_url=urlencode ($mosConfig_live_site.$_SERVER['REQUEST_URI']);

	$this_url =urlencode ( $mosConfig_live_site. '/index.php?option=com_content&task=view&id='
           . $row->id .'&Itemid='. $Itemid.'&page='. @$page);
    
	$LANG=$lang_strings[$param_tolang];	
	if($param_showimage ==1)
	$LANG='<img src="mambots/content/mosGtranslate/'.$param_tolang.'_flag.gif" align="absmiddle" alt="Translate to '
		  .$LANG.'" text="Translate to '.$LANG.'" BORDER=0 WIDTH=16 HEIGHT=16>';
	
	$contentstring="<a href='$gt_url'>$param_textbefore <LANG> $param_textafter</a>";

     //           str_replace( search  value              string    
	$contentstring=str_replace("<URL>",$this_url,         $contentstring);
	$contentstring=str_replace("<FROM>",$param_fromlang,  $contentstring);
	$contentstring=str_replace("<TO>",$param_tolang,      $contentstring);
	$contentstring=str_replace("<LANG>",$LANG,            $contentstring);


	// Add CSS-Class
	if ($param_css) $contentstring='<span class="'.$param_css.'">'.$contentstring.'</span>';

	// Choose Position
	switch ($param_position) {
		case 1: //first line of content
			$row->text=$contentstring."<br>".$row->text;
			break;
		case 2:  // last line of content
			$row->text=$row->text."<br>".$contentstring;
			break;
		default:  // in title
			$row->title.=" ".$contentstring;
			break;
	}
	return true;
}
?>

